clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
linea=3;
shift =2;


%load dati numerici
load('Modello_Statico_NW_D65_ps200.mat')
load('Modello_Statico_NW_D65_ps300.mat')
load('Modello_Statico_NW_D65_ps400.mat')
load('Modello_Statico_NW_D65_ps500.mat') 


%load dati sperimentali
load('Statica_NW_D65_ps200_2.mat')
load('Statica_NW_D65_ps300_1.mat')
load('Statica_NW_D65_ps400_2.mat')
load('Statica_NW_D65_ps500_1.mat')


%% 
%portanza
figure
plot(h200(1:length(Qin200)),F200,'r','linewidth',linea),hold on
plot(h300(1:length(Qin300)),F300,'b','linewidth',linea),hold on
plot(h400(1:length(Qin400)),F400,'g','linewidth',linea),hold on
plot(h500(1:length(Qin500)),F500,'y','linewidth',linea),hold on
plot(h_NW200_2+shift,F_NW200_2,'o','Color', [0.5, 0, 0]),hold on
plot(h_NW300_1+shift,F_NW300_1,'o','Color', [0, 0, 0.5]),hold on
plot(h_NW400_2+shift,F_NW400_2,'o','Color', [0, 0.5, 0]),hold on
plot(h_NW500_1+2.8,F_NW500_1,'o', 'Color', [0.8, 0.6, 0]),hold on
legend('Numerical 2 bar','Numerical 3 bar','Numerical 4 bar','Numerical 5 bar','Experimental 2 bar','Experimental 3 bar','Experimental 4 bar','Experimental 5 bar')
xlabel('Air gap height ($\mu m$)'),ylabel('Force (N)')
grid on, zoom on
xlim([5 25])


%% 

%portata
figure
plot(h200(1:length(Qin200)),Qin200,'r','linewidth',linea),hold on
plot(h300(1:length(Qin300)),Qin300,'b','linewidth',linea),hold on
plot(h400(1:length(Qin400)),Qin400,'g','linewidth',linea),hold on
plot(h500(1:length(Qin500)),Qin500,'y','linewidth',linea),hold on
plot(h_NW200_2+shift,Q_NW200_2,'o','Color', [0.5, 0, 0]),hold on
plot(h_NW300_1+shift,Q_NW300_1,'o','Color', [0, 0, 0.5]),hold on
plot(h_NW400_2+1.3,Q_NW400_2,'o','Color', [0, 0.5, 0]),hold on
plot(h_NW500_1+2.7,Q_NW500_1,'o','Color', [0.8, 0.6, 0]),hold on
legend('Numerical 2 bar','Numerical 3 bar','Numerical 4 bar','Numerical 5 bar','Experimental 2 bar','Experimental 3 bar','Experimental 4 bar','Experimental 5 bar')
xlabel('Air gap height ($\mu m$)'),ylabel('Flow (l/min) ANR 20 $^{\circ}$')
grid on, zoom on
xlim([5 25])

%% 

%rigidezza
figure
plot(h200(1:length(Qin200)),ks200,'r','linewidth',linea),hold on
plot(h300(1:length(Qin300)),ks300,'b','linewidth',linea),hold on
plot(h400(1:length(Qin400)),ks400,'g','linewidth',linea),hold on
plot(h500(1:length(Qin500)),ks500,'y','linewidth',linea),hold on
plot(h_NW200_2(100:end-400)+shift,ks_NW200_2(100:end-400),'o','Color', [0.5, 0, 0]),hold on
plot(h_NW300_1(100:end-400)+shift,ks_NW300_1(100:end-400),'o','Color', [0, 0, 0.5]),hold on
plot(h_NW400_2(100:end-400)+1.7,ks_NW400_2(100:end-400),'o','Color', [0, 0.5, 0]),hold on
plot(h_NW500_1(100:end-400)+2.6,ks_NW500_1(100:end-400),'o','Color', [0.8, 0.6, 0]),hold on
legend('Numerical 2 bar','Numerical 3 bar','Numerical 4 bar','Numerical 5 bar','Experimental 2 bar','Experimental 3 bar','Experimental 4 bar','Experimental 5 bar')
xlabel('Air gap height ($\mu m$)'),ylabel('Stiffness ($\frac{N}{\mu m}$)')
grid on, zoom on
xlim([5 25]),ylim([0 120])
